local modName = g_currentModName

EngineStartDisplay = {}
local EngineStartDisplay_mt = Class(EngineStartDisplay, HUDDisplay)

function EngineStartDisplay.new()
    local self = EngineStartDisplay:superClass().new(EngineStartDisplay_mt)

    local r, g, b, a = unpack(HUD.COLOR.ACTIVE)
    self.iconOverlay = g_overlayManager:createOverlay("gui.engine", 0, 0, 0, 0, modName)
    self.iconOverlay:setColor(r, g, b, a)

    self.title = ""
    self.text = g_i18n:getText("engineStarting", modName)
    self.displayTime = 0

    self:setVisible(false)

    self:storeScaledValues()
    g_messageCenter:subscribe(MessageType.SETTING_CHANGED[GameSettings.SETTING.UI_SCALE], self.storeScaledValues, self)

    return self
end

function EngineStartDisplay:setVisible(isVisible)
    EngineStartDisplay:superClass().setVisible(self, isVisible)

    if isVisible then
        g_currentMission:addUpdateable(self)
        g_currentMission:addDrawable(self)
    else
        g_currentMission:removeDrawable(self)
        g_currentMission:removeUpdateable(self)
    end
end

function EngineStartDisplay:storeScaledValues()
    local offsetX, offsetY = self:scalePixelValuesToScreenVector(0, 0)
    local posX = 0.5 + offsetX
    local posY = g_hudAnchorBottom + offsetY
    self:setPosition(posX, posY)

    local iconWidth, iconHeight = self:scalePixelValuesToScreenVector(64, 48)
    self.iconOverlay:setDimension(iconWidth, iconHeight)
    self.iconOffsetX, self.iconOffsetY = self:scalePixelValuesToScreenVector(5, -4)

    self.titleTextSize = self:scalePixelToScreenHeight(15)
    self.titleTextOffsetY = self:scalePixelToScreenHeight(5)

    self.textSize = self:scalePixelToScreenHeight(26)
    self.textOffsetX, self.textOffsetY = self:scalePixelValuesToScreenVector(10, 1)
    self.textMaxWidth = self:scalePixelToScreenWidth(500)
end

function EngineStartDisplay:update(dt)
    EngineStartDisplay:superClass().update(self, dt)

    if self:getVisible() then
        self.displayTime = self.displayTime - dt
        if self.displayTime < 0 then
            self:setVisible(false)
        end
    end
end

function EngineStartDisplay:draw()
    if not g_currentMission.hud.isVisible or g_currentMission.hud.contextActionDisplay:getVisible() or g_currentMission.hud.ingameMessage:getVisible() then return end

    if g_currentMission.hud.vehicleNameDisplay.overlay:getVisible() then
        g_currentMission.hud.vehicleNameDisplay.overlay:setVisible(false)
    end

    setTextWrapWidth(self.textMaxWidth)

    local width = self.iconOverlay.width + self.iconOffsetX + self.textOffsetX + getTextWidth(self.textSize, self.text)
    local posX, posY = self:getPosition()
    local currentPosX = posX - width * 0.5

    local textHeight = getTextHeight(self.textSize, self.text)
    local totalHeight = textHeight + self.titleTextOffsetY + self.titleTextSize

    local iconPosY = posY + (totalHeight - self.iconOverlay.height) * 0.5
    self.iconOverlay:setPosition(currentPosX + self.iconOffsetX, iconPosY)
    self.iconOverlay:render()

    currentPosX = self.iconOverlay.x + self.iconOverlay.width

    setTextColor(unpack(HUD.COLOR.ACTIVE))
    setTextBold(true)
    setTextAlignment(RenderText.ALIGN_LEFT)
    renderText(currentPosX + self.textOffsetX, posY + textHeight + self.titleTextOffsetY, self.titleTextSize, self.title)

    setTextColor(1, 1, 1, 1)
    setTextBold(false)
    setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_BOTTOM)
    renderText(currentPosX + self.textOffsetX, posY + self.textOffsetY, self.textSize, self.text)
    setTextWrapWidth(0)
    setTextVerticalAlignment(RenderText.VERTICAL_ALIGN_BASELINE)
end

function EngineStartDisplay:show(displayTime, name)
    if displayTime == nil or displayTime <= 0 then return end
    self.displayTime = displayTime
    self.title = utf8ToUpper(name or "")
    if self:getVisible() then return end
    self:setVisible(true)
end

function EngineStartDisplay:hide()
    if not self:getVisible() then return end
    self:setVisible(false)
    self.displayTime = 0
    self.title = ""
end