-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

local thMain = g_thPFConfig
THFillUnitSpec = {}
THFillUnitSpec.SPEC_KEY = "spec_" .. thMain.modName .. ".thFillUnit"
THFillUnitSpec.XML_KEY = thMain.xmlKey .. ".fillUnit"
THFillUnitSpecTable = {}
local function initScript()
end
local function getSpecTable(parentEnv)
    return THUtils.call(function()
        if parentEnv ~= nil then
            return parentEnv[THFillUnitSpec.SPEC_KEY]
        end
    end)
end
THFillUnitSpec.getSpecTable = getSpecTable
function THFillUnitSpec.prerequisitesPresent(specializations)
    if SpecializationUtil.hasSpecialization(FillUnit, specializations) then
        return true
    end
    return false
end
function THFillUnitSpec.registerOverwrittenFunctions(vehicleType)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "loadFillUnitFromXML", THFillUnitSpec.sInj_loadFillUnitFromXML)
end
function THFillUnitSpec.sInj_loadFillUnitFromXML(self, superFunc, xmlFile, xmlKey, ...)
    local xmlFileType = type(xmlFile)
    if (xmlFileType == THValueType.TABLE or (xmlFileType == THValueType.NUMBER and xmlFile ~= 0))
        and type(xmlKey) == THValueType.STRING
    then
        THUtils.call(function()
            local fillTypeNames = THUtils.getXMLValue(xmlFile, XMLValueType.STRING, xmlKey, "#fillTypes")
            local fillTypeCategories = THUtils.getXMLValue(xmlFile, XMLValueType.STRING, xmlKey, "#fillTypeCategories")
            if (fillTypeNames ~= nil and fillTypeNames ~= "")
                or (fillTypeCategories ~= nil and fillTypeCategories ~= "")
            then
                local newFillTypeNames = thMain:addExtendedSprayTypesToFillTypeList(fillTypeNames, fillTypeCategories, nil, true, true)
                if newFillTypeNames ~= nil then
                    if THDebugUtil.getIsEnabled(thMain.debugFlagId) then
                        local vehicleName = self:getName() or "THFillUnitSpec"
                        THUtils.displayMsg("%s: updated fill unit fill types: %s", vehicleName, newFillTypeNames)
                    end
                    THUtils.setXMLValue(xmlFile, XMLValueType.STRING, xmlKey, "#fillTypes", newFillTypeNames)
                    if fillTypeCategories ~= nil then
                        THUtils.removeXMLProperty(xmlFile, xmlKey .. "#fillTypeCategories")
                    end
                end
            end
        end)
    end
    return superFunc(self, xmlFile, xmlKey, ...)
end
THUtils.call(initScript)