-- Copyright 2024-2025 by Todd Hundersmarck (ThundR) 
-- All Rights Reserved

local thMain = g_thPFConfig
local thI18n = thMain.i18n
THExtendedSprayerHUDExtension = {}
local THExtendedSprayerHUDExtension_mt = THUtils.createClass(THExtendedSprayerHUDExtension)
THExtendedSprayerHUDExtension.DATA_KEY = thMain.modName .. ".thExtendedSprayerHUDExtension"
THExtendedSprayerHUDExtension.TEXT_KEYS = {
    "headline_ph_lime",
    "headline_n_solidFertilizer",
    "headline_n_liquidFertilizer",
    "headline_n_slurryTanker",
    "headline_n_manureSpreader"
}
local debugFlagId = THDebugUtil.createFlagId("THExtendedSprayerHUDExtension")
THExtendedSprayerHUDExtension.debugFlagId = debugFlagId
local function initScript()
    local pfData = thMain.precisionFarming
    if pfData ~= nil and pfData.isFound then
        local ExtendedSprayerHUDExtension = pfData.modEnv.ExtendedSprayerHUDExtension
        THUtils.setFunctionHook(ExtendedSprayerHUDExtension, "new", false, false, nil, THExtendedSprayerHUDExtension.gInj_new)
        THUtils.setFunctionHook(ExtendedSprayerHUDExtension, "draw", false, false, nil, THExtendedSprayerHUDExtension.gInj_draw)
    end
end
local function getCustomData(parentEnv)
    if parentEnv ~= nil then
        return THUtils.getDataTable(parentEnv, THExtendedSprayerHUDExtension.DATA_KEY)
    end
end
THExtendedSprayerHUDExtension.getCustomData = getCustomData
function THExtendedSprayerHUDExtension.gInj_new(superFunc, ...)
    local function appendFunc(rParentEnv, ...)
        if rParentEnv ~= nil then
            THUtils.call(function()
                local self = THUtils.createDataTable(rParentEnv, THExtendedSprayerHUDExtension.DATA_KEY, THExtendedSprayerHUDExtension_mt)
                if self ~= nil then
                    self.defaultTexts = {}
                    for key, value in pairs(rParentEnv.texts) do
                        self.defaultTexts[key] = value
                    end
                    self.texts = {}
                    for _, textKey in pairs(THExtendedSprayerHUDExtension.TEXT_KEYS) do
                        local absTextKey = "thHudExtensionSprayer_" .. textKey
                        if thI18n:hasText(absTextKey) then
                            self.texts[textKey] = thI18n:getText(absTextKey)
                        end
                    end
                end
            end)
        end
        return rParentEnv, ...
    end
    return appendFunc(superFunc(...))
end
function THExtendedSprayerHUDExtension.gInj_draw(superFunc, parentEnv, ...)
    local self = getCustomData(parentEnv)
    local pfData = thMain.precisionFarming
    local lastPHMapUsageSprayType, isPHMapUsageSet = nil, false
    if self ~= nil
        and pfData ~= nil and pfData.isFound
    then
        THUtils.call(function()
            local ExtendedSprayer = pfData.modEnv.ExtendedSprayer
            local extendedSprayerSpec = parentEnv.extendedSprayer
            local vehicle = parentEnv.vehicle
            if ExtendedSprayer ~= nil and vehicle ~= nil
                and extendedSprayerSpec ~= nil
            then
                local thSprayerSpec = THSprayerSpec.getSpecTable(vehicle)
                if thSprayerSpec ~= nil then
                    local sourceFillType, sourceFillUnitIndex, sourceVehicle = THSprayerSpec.getSprayerFillType(vehicle)
                    if sourceFillType ~= nil and sourceFillType ~= FillType.UNKNOWN
                        and sourceFillUnitIndex ~= nil
                        and sourceVehicle ~= nil
                    then
                        local xtSprayTypeData = thMain:getExtendedSprayTypeByFillType(sourceFillType)
                        if xtSprayTypeData ~= nil then
                            THSprayerSpec.setCurrentSprayerType(vehicle, xtSprayTypeData.fillTypeIndex)
                            local isSprayTypeMapped, isFillTypeMapped = xtSprayTypeData:activateMapping()
                            if THDebugUtil.getIsEnabled(debugFlagId, THDebugLevel.UPDATE) then
                                if isSprayTypeMapped then
                                    THUtils.displayMsg("THExtendedSprayerHUDExtension (draw): Spray type %q mapped to %q", xtSprayTypeData.baseId, xtSprayTypeData.id)
                                end
                                if isFillTypeMapped then
                                    THUtils.displayMsg("THExtendedSprayerHUDExtension (draw): Spray fill type %q mapped to %q", xtSprayTypeData.baseFillTypeId, xtSprayTypeData.fillTypeId)
                                end
                                if isSprayTypeMapped or isFillTypeMapped then
                                    THUtils.displayMsg("")
                                end
                            end
                            local headlineTextKey = nil
                            if xtSprayTypeData.group == THPFConfig.SPRAY_TYPE_GROUP.FERTILIZER then
                                if xtSprayTypeData.isLiquid then
                                    headlineTextKey = "headline_n_liquidFertilizer"
                                else
                                    headlineTextKey = "headline_n_solidFertilizer"
                                end
                            elseif xtSprayTypeData.group == THPFConfig.SPRAY_TYPE_GROUP.MANURE
                                or xtSprayTypeData.group == THPFConfig.SPRAY_TYPE_GROUP.DIGESTATE
                            then
                                if xtSprayTypeData.isLiquid then
                                    headlineTextKey = "headline_n_slurryTanker"
                                else
                                    headlineTextKey = "headline_n_manureSpreader"
                                end
                            elseif xtSprayTypeData.group == THPFConfig.SPRAY_TYPE_GROUP.LIME then
                                headlineTextKey = "headline_ph_lime"
                            end
                            if headlineTextKey ~= nil and self.texts[headlineTextKey] ~= nil then
                                local headlineText = string.format(self.texts[headlineTextKey], xtSprayTypeData.fillTypeTitle)
                                parentEnv.texts[headlineTextKey] = headlineText
                            end
                            if xtSprayTypeData.group == THPFConfig.SPRAY_TYPE_GROUP.LIME then
                                local thPHMapData = THPHMap.getCustomData(parentEnv.pHMap)
                                if thPHMapData ~= nil then
                                    lastPHMapUsageSprayType = thPHMapData:setUsageSprayType(xtSprayTypeData.sprayTypeIndex)
                                    isPHMapUsageSet = true
                                end
                            end
                        end
                    end
                end
            end
        end)
    end
    local function appendFunc(...)
        if self ~= nil
            and pfData ~= nil and pfData.isFound
        then
            THUtils.call(function()
                thMain:resetExtendedSprayTypeConstants()
                local vehicle = parentEnv.vehicle
                if vehicle ~= nil then
                    local thSprayerSpec = THSprayerSpec.getSpecTable(vehicle)
                    if thSprayerSpec ~= nil then
                        THSprayerSpec.resetSprayerTypes(vehicle)
                    end
                end
                for textKey in pairs(self.texts) do
                    local defaultText = self.defaultTexts[textKey]
                    if defaultText ~= nil then
                        parentEnv.texts[textKey] = defaultText
                    end
                end
                if isPHMapUsageSet then
                    local thPHMapData = THPHMap.getCustomData(parentEnv.pHMap)
                    if thPHMapData ~= nil then
                        thPHMapData:setUsageSprayType(lastPHMapUsageSprayType)
                    end
                end
            end)
        end
        return ...
    end
    return appendFunc(superFunc(parentEnv, ...))
end
THUtils.call(initScript)