RollerLoadSettingsEvent = {};
RollerLoadSettingsEvent_mt = Class(RollerLoadSettingsEvent, Event);
InitEventClass(RollerLoadSettingsEvent, "RollerLoadSettingsEvent");

RollerLoadSettingsEvent.NUM_BITS_SETTINGS_MINMAX = 1;

---Create instance of Event class
function RollerLoadSettingsEvent.emptyNew()
    local self = Event.new(RollerLoadSettingsEvent_mt);
    return self;
end;

---Create new instance of event
function RollerLoadSettingsEvent.new(minMax)
    local self = RollerLoadSettingsEvent.emptyNew();
    self.minMax = minMax;
    return self;
end;

---Called on client side on join
function RollerLoadSettingsEvent:readStream(streamId, connection)
    if g_server == nil then
        self.minMax = streamReadInt8(streamId, RollerLoadSettingsEvent.NUM_BITS_SETTINGS_MINMAX);
        
        self:run(connection);
    end;
end;

---Called on server side on join
function RollerLoadSettingsEvent:writeStream(streamId, connection)
	if g_additionalContractTypes.settings["rollerMission_minMax"] ~= nil then
		streamWriteInt8(streamId, g_additionalContractTypes.settings["rollerMission_minMax"], RollerLoadSettingsEvent.NUM_BITS_SETTINGS_MINMAX);
	end;	
end;

---Run action on receiving side
function RollerLoadSettingsEvent:run(connection)
	if g_server ~= nil then
		g_server:broadcastEvent(RollerLoadSettingsEvent.new(g_additionalContractTypes.settings["rollerMission_minMax"]), false);				
		return;
	end;	
	if self.minMax ~= nil then
		g_additionalContractTypes.typ["rollerMission"]:setMaxNumInstance(self.minMax);			
	end;
end;


