UniversalMissionHotspot = {};
local UniversalMissionHotspot_mt = Class(UniversalMissionHotspot, MapHotspot);

function UniversalMissionHotspot.new(customMt, farmId, typ, typOverlay, blinking, color, fillTypeName)	
	local self = MapHotspot.new(customMt or UniversalMissionHotspot_mt);
	local width, height = getNormalizedScreenValues(50, 50);
	self.width = width;
	self.height = height;	
	if fillTypeName ~= nil and fillTypeName:len() > 0 and fillTypeName ~= "UNKNOWN" then
		local overlayFillTypesGroup = g_currentMission.hlUtils.overlays["LS_FillTypes"]["fillTypes"];
		local overlayFillTypesByName = g_currentMission.hlUtils.overlays.byName["LS_FillTypes"]["fillTypes"];
		local fillType = g_fillTypeManager:getFillTypeByName(fillTypeName);
		if fillType ~= nil then
			local fillOrTypeOverlay = overlayFillTypesGroup[overlayFillTypesByName[g_fillTypeManager:getFillTypeNameByIndex(fillType.index)]];
			if fillOrTypeOverlay ~= nil then
				g_currentMission.hlUtils.setOverlay(fillOrTypeOverlay, 0, 0, self.width * 0.35, self.height * 0.35);
				self.fillOrTypeOverlay = fillOrTypeOverlay;
			end;
		end;
	end;
	if self.fillOrTypeOverlay == nil and typOverlay ~= nil then 
		if typOverlay == "blank" then typOverlay = "unknown1";end;
	end;	
	if typOverlay == nil then typOverlay = typ;end;	
	local overlayModGroup = g_currentMission.hlUtils.overlays["AdditionalContracts"]["mapHotspots"];
	local overlayModByName = g_currentMission.hlUtils.overlays.byName["AdditionalContracts"]["mapHotspots"];		
	local overlay = overlayModGroup[overlayModByName[tostring(typOverlay)]];
	if overlay == nil then overlay = overlayModGroup[overlayModByName["unknown1"]];end;
	g_currentMission.hlUtils.setOverlay(overlay, 0, 0, self.width * 0.5, self.height * 0.5);
	
	self:setOwnerFarmId(farmId);
	local iconColor = color or "darkGreen";
	local setFarmColor = false;
	if color == nil and farmId ~= nil and g_currentMission.missionDynamicInfo.isMultiplayer then	
		color = self:getOwnerFarmColor(farmId)
		if color ~= nil then iconColor = color;setFarmColor = true;end;		
	end;
	if iconColor ~= nil and setFarmColor then g_currentMission.hlUtils.setBackgroundColor(overlay, iconColor);elseif iconColor ~= nil and not setFarmColor then g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(iconColor, true));end;	
	if blinking ~= nil and blinking then self:setBlinking(true);end;
	self.overlay = overlay;	
	self.typ = typ;
	self.worldRadius = 20;	
	return self;
end;

function UniversalMissionHotspot:setScale(scale)
 
end;

function UniversalMissionHotspot:getWidth()	
	return self.lastRenderedIcon == nil and 0 or self.lastRenderedIcon.width;	
end;

function UniversalMissionHotspot:getHeight()
	return self.lastRenderedIcon == nil and 0 or self.lastRenderedIcon.height;	
end;

function UniversalMissionHotspot:getDimension()	
	if self.lastRenderedIcon == nil then
		return 0, 0;
	else
		return self.lastRenderedIcon.width, self.lastRenderedIcon.height;
	end;	
end;

function UniversalMissionHotspot:getOwnerFarmColor(farmId)	
	local farm = g_farmManager:getFarmById(farmId);
	if farm ~= nil then
		local color = Farm.COLORS[farm.color];
		return {color[1], color[2], color[3], 1};		
	end;	
end;

function UniversalMissionHotspot:getCategory()
	return MapHotspot.CATEGORY_MISSION;
end;

function UniversalMissionHotspot:getIsPersistent()
	return false;
end;

function UniversalMissionHotspot:getRenderLast()
	return true;
end;

function UniversalMissionHotspot:render(x, y, rotation, small)
	if self.overlay ~= nil then		
		if small then
			x = x - self.overlay.width * 0.5;
			y = y - self.overlay.height * 0.5;		
		end;
		g_currentMission.hlUtils.setOverlay(self.overlay, x, y);
		if self.fillOrTypeOverlay ~= nil then
			g_currentMission.hlUtils.setOverlay(self.fillOrTypeOverlay, self.overlay.x+(self.overlay.width/2)-(self.fillOrTypeOverlay.width/2), self.overlay.y+(self.overlay.height/2)-(self.fillOrTypeOverlay.height/2)+0.001);
		end;		
		if self.isBlinking and self:getCanBlink() then
					
		end;		
		self.overlay:render();
		if self.fillOrTypeOverlay ~= nil then self.fillOrTypeOverlay:render();end;
	end;
end;
