ChaffLoadSettingsEvent = {};
ChaffLoadSettingsEvent_mt = Class(ChaffLoadSettingsEvent, Event);
InitEventClass(ChaffLoadSettingsEvent, "ChaffLoadSettingsEvent");

ChaffLoadSettingsEvent.NUM_BITS_SETTINGS_MINMAX = 1;

---Create instance of Event class
function ChaffLoadSettingsEvent.emptyNew()
    local self = Event.new(ChaffLoadSettingsEvent_mt);
    return self;
end;

---Create new instance of event
function ChaffLoadSettingsEvent.new(minMax)
    local self = ChaffLoadSettingsEvent.emptyNew();
    self.minMax = minMax;
    return self;
end;

---Called on client side on join
function ChaffLoadSettingsEvent:readStream(streamId, connection)
    if g_server == nil then
        self.minMax = streamReadInt8(streamId, ChaffLoadSettingsEvent.NUM_BITS_SETTINGS_MINMAX);
        
        self:run(connection);
    end;
end;

---Called on server side on join
function ChaffLoadSettingsEvent:writeStream(streamId, connection)
	if g_additionalContractTypes.settings["chaffMission_minMax"] ~= nil then
		streamWriteInt8(streamId, g_additionalContractTypes.settings["chaffMission_minMax"], ChaffLoadSettingsEvent.NUM_BITS_SETTINGS_MINMAX);
	end;	
end;

---Run action on receiving side
function ChaffLoadSettingsEvent:run(connection)
	if g_server ~= nil then
		g_server:broadcastEvent(ChaffLoadSettingsEvent.new(g_additionalContractTypes.settings["chaffMission_minMax"]), false);				
		return;
	end;	
	if self.minMax ~= nil then
		g_additionalContractTypes.typ["chaffMission"]:setMaxNumInstance(self.minMax);			
	end;
end;


